'
'  This is a simple routine that may aid in seeing how to use the QBSVGA
' routines and where to put REGTYPE.INC.  If you go to compile and link
' it, use QB.LIB (in addition to whatever other libraries you would
' normally use).  This applies anytime you use the QBSVGA routines.
' Similarly, if you're going to use these routines from within the QB
' IDE, run QB with the "/L" command-line option.
'
'  Put the contents of REGTYPE.INC here.
'
    DIM CLA AS LONG,Q AS LONG
    CALL BSCREEN(15!,7!,0!,0!)
    CALL BLINE(10!,10!,790!,590!,14!,"BF")
    CALL BCIRCLE(400!,300!,290!,13!,0!,0!,1!)
    CALL BCIRCLE(400!,300!,150!,12!,0!,1.57!,1!)
    S=3.141593
    E=3*3.141593/2
    CALL BCIRCLE(400!,300!,150!,11!,S,E,1!)
    CALL BLINE(30!,30!,30!,350!,15!,"L")
    CALL BCOLOR(12!)
'
'  A negative number input to any of the QBSVGA routines for the color
' will be reset to the default color defined in the call to BSCREEN
' (or BCOLOR).  (An exception to this is BVIEW; it uses color 0 in this
' situation.)
'
    CALL BLINE(0!,0!,799!,599!,-1!,"L")
    CALL BCOLOR(9!)
    CALL BLOCATE(30!,10!)
    CALL BPRINT("This is an example.")
    PCOLOR=BPOINT(799!,599!)
    CALL BLOCATE(3!,3!)
    A$="Color of pixel at (800,600) is "+LTRIM$(RTRIM$(STR$(PCOLOR)))+".;"
    CALL BPRINT(A$)
    CALL BPRINT("    (Wait...)")
    RX=799
    RY=599
    CALL BLINE(0!,0!,RX,RY,10!,"B")
    SLEEP 5
    CALL BSCREEN(14!,6!,0!,0!)
    CALL BLOCATE(1!,3!)
    CALL BPRINT("Now I am going to use a graphics viewport;")
    CALL BPRINT(" in a different screen mode.")
    CALL BPRINT(" ")
    CALL BPRINT("(Wait...)")
    CALL BVIEW(40!,60!,230!,250!,0!,7!)
    CALL BCIRCLE(100!,120!,40!,7!,0!,0!,2!)
'
'  Paint inside of circle.
'
    CALL BPAINT(100!,120!,11!,-1!)
'
'  Paint top, bottom, and righthand portions of exterior of circle.
'
    CALL BPAINT(141!,120!,13!,-1!)
'
'  Paint remaining portion of circle exterior.
'
    CALL BPAINT(59!,120!,13!,-1!)
'
'  Set color palette to QB standard 256-color SCREEN 13 values.  (SVGA
' color palettes are not generally well-defined above the first 64
' values.)
'
    CALL RESETPALETTE
'
'  Demonstrate how QBSVGA's BGET and BPUT statements work.
'
    DIM PICT(1 TO 9122) AS LONG
'
'  Get memory location of PICT array and store picture there.
'
    SM=VARSEG(PICT(1)) : OS=VARPTR(PICT(1))
    CALL BGET(0!,0!,190!,190!,SM,OS)
    CALL BCLS(0!)
    A$="I have saved that last picture in an array."
    CALL BPRINT(A$)
    A$="Press a key and I'll show it to you in a different location."
    CALL BPRINT(A$)
    CALL BPRINT(" ")
    A$="(The location isn't that different; it will still be on your screen.)"
    CALL BPRINT(A$)
10 IF INKEY$="" THEN GOTO 10
    CALL BCLS(0!)
    CALL BPUT(0!,0!,SM,OS,"PSET")
    CALL BLOCATE(13!,10!)
    CALL BPRINT("Wait...")
    SLEEP 5
    CALL BCLS(0!)
    CALL BLOCATE(1!,10!)
    A$="Now I'm going to try to print 256 colors in that last graphics mode."
    CALL BPRINT(A$)
    CALL BLOCATE(3!,1!)
    C=0
    FOR I=33 TO 126
    CALL BCOLOR(C)
    CALL BPRINT(CHR$(I)+";")
    C=C+1
    NEXT I
    FOR I=33 TO 126
    CALL BCOLOR(C)
    CALL BPRINT(CHR$(I)+";")
    C=C+1
    NEXT I
    FOR I=33 TO 100
    CALL BCOLOR(C)
    CALL BPRINT(CHR$(I)+";")
    C=C+1
    NEXT I
    CALL BPRINT(" ")
    CALL BCOLOR(7!)
    CALL BPRINT(" ")
    CALL BPRINT(" ")
    CALL BPRINT("Now I'm going to do the same thing ;")
    CALL BPRINT("but in a more graphical manner.")
    CALL BPRINT(" ")
    CALL BPRINT(" ")
'
'  Get current row and make at least approximate conversion to pixel
' coordinates.
'
    DUMMY=BPOS(ROW)
    ROW=ROW*16
    FOR I=0 TO 511 STEP 2
    C=INT(I/2)
    CALL BLINE(I,ROW,I+1,ROW+15,C,"BF")
    NEXT I
    CALL BLOCATE(ROW/16+4,1!)
    CALL BPRINT("Press a key to see color palette change ;")
    CALL BPRINT("(and then press key to quit).")
260 IF INKEY$="" THEN GOTO 260
'
'  Demonstrate BPALETTE.
'
'  First 64 colors add red to an otherwise 0 gray-scale.
'
    FOR I=0 TO 127 STEP 2
    Q=CLNG(I/2) : B=CSNG(Q)
    CALL BPALETTE(B,Q)
    NEXT I
'
'  Next 64 colors add green to a maximal intensity red attribute.
'
    FOR I=128 TO 255 STEP 2
    Q=CLNG(I/2)-64& : B=CSNG(Q)+64
    CLA=256&*Q+63&
    CALL BPALETTE(B,CLA)
    NEXT I
'
'  Next 64 colors add blue to a maximal intensity red/green attribute
' and simultaneously decreases the red.
'
    FOR I=256 TO 383 STEP 2
    Q=CLNG(I/2)-128& : B=CSNG(Q)+128
    CLA=65536&*Q+16128&+(63&-Q)
    CALL BPALETTE(B,CLA)
    NEXT I
'
'  Final 64 colors decrease green from maximal intensity blue/green
' attribute.
'
    FOR I=384 TO 511 STEP 2
    Q=CLNG(I/2)-192& : B=CSNG(Q)+192
    CLA=4128768&+256&*(63&-Q)
    CALL BPALETTE(B,CLA)
    NEXT I
270 IF INKEY$="" THEN GOTO 270
    CALL BSCREEN(0!,7!,0!,0!)
    END
'
'  Put the contents of QBSVGA.BAS here.
